/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.powers;

import com.megacrit.cardcrawl.actions.common.DiscardAction;
import com.megacrit.cardcrawl.actions.utility.UseCardAction;
import com.megacrit.cardcrawl.actions.utility.WaitAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.localization.PowerStrings;
import com.megacrit.cardcrawl.powers.AbstractPower;

public class ShriekPower
extends AbstractPower {
    public static final String POWER_ID = "Shriek From Beyond";
    private static final PowerStrings powerStrings = CardCrawlGame.languagePack.getPowerStrings("Shriek From Beyond");
    public static final String NAME = ShriekPower.powerStrings.NAME;
    public static final String[] DESCRIPTIONS = ShriekPower.powerStrings.DESCRIPTIONS;

    public ShriekPower(AbstractCreature owner) {
        this.name = NAME;
        this.ID = POWER_ID;
        this.owner = owner;
        this.amount = -1;
        this.updateDescription();
        this.img = ImageMaster.loadImage("images/powers/32/shriek.png");
    }

    @Override
    public void updateDescription() {
        this.description = DESCRIPTIONS[0];
    }

    @Override
    public void onUseCard(AbstractCard card, UseCardAction action) {
        if (card.type == AbstractCard.CardType.ATTACK) {
            this.flash();
            AbstractDungeon.actionManager.addToBottom(new WaitAction(0.5f));
            AbstractDungeon.actionManager.addToBottom(new DiscardAction(AbstractDungeon.player, this.owner, 1, true, false));
        }
    }
}

